/*
 * portlet: faq
 * portlet-type: faq 
 * portlet-group: common
 * portlet-name: <i class="fa fa-question"></i> FAQ
 * portlet-image: assets/images/no-image.png
 * portlet-asset-js: plugins/faq/assets/js/faq-portlet.js
 */
Faq_Portlet_Class = function(){
	this.toolbar_name = 'FAQ';
}
$.extend(Faq_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Faq_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<div></div>');
	var css = {};
	if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
		$.each( portlet.style, function( name, value ) {
			if ($.trim(value) != ''){
				if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
					css[name] = value + 'px';
				}else{
					css[name] = value;
				}
			}
		});
		div.css(css);
	}
	
	if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
		$.each( portlet.attr, function( name, value ) {
			if ($.trim(value) != ''){
				div.attr(name,value);
			}
		});
	}
	
	div.append(content);
	
	return div;
};
Faq_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
	var sortable_id = $('#portlets_modal').data('sortable-id');
	
	if (toolbar == false){
	    var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	    var style = {};
	    $.each( fields, function( i, field ) {
	    	style[field.name] = field.value;
	    });
	    portlet.style = style;
	    
	    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
	    var attr = {};
	    $.each( fields, function( i, field ) {
	    	attr[field.name] = field.value;
	    });
	    portlet.attr = attr;
	    portlet.faq_question = $('#portlets_modal #faq-question').val();
	    portlet.faq_answer = tinymce.get('faq-answer').getContent();
	}
    
    var faq_id = Bootstrap_Builder.guid();
    var faq_div = $('<div></div>');
    faq_div.append(
		$('<h4></h4>')
		.attr('id',faq_id + '-title')
		.append(
			$('<span class="icon"></span>')
			.css({display:'inline-block',width:'15px'})
			.text('+ ')
		)
		.append(
			$('<a></a>')
			.addClass('collapsed')
			.attr('data-toggle','collapse')
			.attr('href','#' + faq_id)
			.attr('aria-expanded','false')
			.attr('aria-controls',faq_id)
			.append(portlet.faq_question)
		)
    )
    .append(
		$('<div></div>')
		.css({paddingLeft:'15px'})
		.addClass('collapse')
		.addClass('faq-portlet-item')
		.attr('id',faq_id)
		.append(portlet.faq_answer)
    );
    
    var value = faq_div.html();
    _this.portlet_render(portlet_id,sortable_id,value,modal_hide);
};
Faq_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('FAQ');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
                _this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=faq&file=faq-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    	
    	if (portlet.faq_question != undefined && portlet.faq_question != ''){
    		$('#portlets_modal').find('#faq-question').val(portlet.faq_question);
    	}
    	
    	if (portlet.faq_answer != undefined && portlet.faq_answer != null){
            $('#portlets_modal').find('#faq-answer').val(portlet.faq_answer);
        }
        
        tinymce.init({
            selector: '#faq-answer',
            height: 250,
            menubar:false,
            statusbar: false,
            plugins: [
              'autolink lists link image preview',
              'code textcolor',
              'contextmenu paste code'
            ],
            toolbar: ['code | undo redo | styleselect  bold italic underline | forecolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image'],
            content_css:['assets/bootstrap/css/bootstrap.min.css','assets/css/tinymce-content.css']
          });
        
        if (portlet.style != undefined){
	    	$.each( portlet.style, function( name, value ) {
	    		if ($.trim(value) != ''){
		    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
		    			$('#portlets_modal #'+ name).val(value);
		    		}else{
		    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
		    		}
	    		}
	    		
	    	});
        }
        if (portlet.attr != undefined){
	    	$.each( portlet.attr, function( name, value ) {
	    		if ($.trim(value) != ''){
	    			$('#portlets_modal #'+ name).val(value);
	    		}
	    		
	    	});
        }
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Faq_Portlet = new Faq_Portlet_Class();