/*
 * portlet: button
 * portlet-type: button
 * portlet-group: common 
 * portlet-name: Button
 * portlet-image: assets/images/no-image.png
 */
Button_Portlet_Class = function(){
	this.file_list = {};
	this.toolbar_name = 'Button';
}
$.extend(Button_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Button_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<div></div>');
	var css = {};
	if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
		$.each( portlet.style, function( name, value ) {
			if ($.trim(value) != ''){
				if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
					css[name] = value + 'px';
				}else{
					css[name] = value;
				}
			}
		});
		div.css(css);
	}
	
	if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
		$.each( portlet.attr, function( name, value ) {
			if ($.trim(value) != ''){
				div.attr(name,value);
			}
		});
	}
	if (portlet.button_alignment != undefined){
		if (portlet.button_alignment != 'inline'){
			$('#'+portlet_id).css({display:'block'});
			div.css({display:'block',marginRight:'0px'});
			div.addClass('text-'+portlet.button_alignment);
		}else{
			$('#'+portlet_id).css({display:'inline-block'});
			div.css({display:'inline-block',marginRight:'3px'});
		}
	}
	div.append(content);
	
	return div;
};

Button_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    if (toolbar == false){
	    var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	    var style = {};
	    $.each( fields, function( i, field ) {
	    	style[field.name] = field.value;
	    });
	    portlet.style = style;
	    
	    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
	    var attr = {};
	    $.each( fields, function( i, field ) {
	    	attr[field.name] = field.value;
	    });
	    portlet.attr = attr;
	    
	    portlet.button_text = $('#portlets_modal #button-text').val();
	    portlet.button_type = $('#portlets_modal #button-type').val();
	    portlet.button_link_flag = $('#portlets_modal input[name="button-link-flag"]:checked').val();
	    portlet.button_link_page = $('#portlets_modal #button-link-page').val();
	    portlet.button_link_text = $('#portlets_modal #button-link-text').val();
	    portlet.button_link_new_tab_flag = $('#portlets_modal input[name="button-link-new-tab-flag"]:checked').val();
	    portlet.button_size = $('#portlets_modal #button-size').val();
	    portlet.button_alignment = $('#portlets_modal #button-alignment').val();
	    portlet.button_icon_flag = $('#portlets_modal input[name="button-icon-flag"]:checked').val();
	    portlet.button_icon = $('#portlets_modal #button-icon').val();
	    portlet.button_icon_alignment = $('#portlets_modal #button-icon-alignment').val();
	    portlet.button_full_width_flag = $('#portlets_modal input[name="button-full-width-flag"]:checked').val();
    }
    
    var button_link = $('<a></a>')
	    			.addClass('btn')
	    			.addClass('btn-'+portlet.button_type)
	    			.addClass('btn-'+portlet.button_size)
	    			.append(portlet.button_text);
    if (portlet.button_icon_flag == 'yes' && portlet.button_icon != ''){
    	if (portlet.button_icon_alignment == 'left'){
    		button_link.prepend(' ');
        	button_link.prepend(
    			$('<i></i>')
    			.css({top:'2px'})
    			.addClass(portlet.button_icon)
        	);
    	}else{
    		button_link.append(' ');
    		button_link.append(
    			$('<i></i>')
    			.css({top:'2px'})
    			.addClass(portlet.button_icon)
        	);
    	}
    }
    if (portlet.button_full_width_flag == 'yes'){
    	button_link.addClass('btn-block');
    }
    if (portlet.button_link_flag == 'yes'){
    	var button_link_url = $.trim(portlet.button_link_page) + '';
    	if (button_link_url == ''){
    		button_link_url = portlet.button_link_text;
    	}else{
    		var object = (_this.file_list[button_link_url] != undefined)?_this.file_list[button_link_url]:'';
    		button_link_url = object.file_name+'.html';
    	}
    	if (button_link_url != ''){
        	button_link.attr('href',button_link_url);
    		if (portlet.button_link_new_tab_flag != undefined && portlet.button_link_new_tab_flag == 'yes'){
    			button_link.attr('target',"_blank");
    		}
    	}
    	
    }
    var value = $('<div></div>').append(button_link).html();
    
    _this.portlet_render(portlet_id,sortable_id,value,modal_hide);
}

Button_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('Button');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=button&file=button-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
        
    	if (portlet.button_text != undefined && portlet.button_text != null){
        	$('#portlets_modal #button-text').val(portlet.button_text);
        }
    	
    	if (portlet.button_type != undefined && portlet.button_type != null){
        	$('#portlets_modal #button-type').val(portlet.button_type);
        }
        
        if (portlet.button_link_flag != undefined && portlet.button_link_flag != null){
        	var button_link_flag = $('#portlets_modal input[name="button-link-flag"][value="'+portlet.button_link_flag+'"]');
        	button_link_flag.attr('checked','checked');
    		if (button_link_flag.val() == 'yes'){
        		$('#button-url-link-container').show();
        	}else{
        		$('#button-url-link-container').hide();
        	}
        }
        
        
        if (portlet.button_link_text != undefined && portlet.button_link_text != null){
        	$('#portlets_modal #button-link-text').val(portlet.button_link_text);
        }
        
        if (portlet.button_link_new_tab_flag != undefined && portlet.button_link_new_tab_flag != null){
        	$('#portlets_modal input[name="button-link-new-tab-flag"][value="'+portlet.button_link_new_tab_flag+'"]').attr('checked','checked');
        }
        
        if (portlet.button_size != undefined && portlet.button_size != null){
        	$('#portlets_modal #button-size').val(portlet.button_size);
        }
        
        if (portlet.button_alignment != undefined && portlet.button_alignment != null){
        	$('#portlets_modal #button-alignment').val(portlet.button_alignment);
        }
        
        if (portlet.button_icon_flag != undefined && portlet.button_icon_flag != null){
        	$('#portlets_modal input[name="button-icon-flag"][value="'+portlet.button_icon_flag+'"]').attr('checked','checked');
        	if (portlet.button_icon_flag == 'yes'){
        		$('#button-font-icon-container').show();
        	}
        }
        
        if (portlet.button_icon != undefined && portlet.button_icon != null){
        	$('#portlets_modal #button-icon').val(portlet.button_icon);
        	$('#portlets_modal #span-button-icon').empty();
        	$('#portlets_modal #span-button-icon').append($('<i></i>').addClass(portlet.button_icon).addClass('fa-lg'));
        }
        
        
        if (portlet.button_icon_alignment != undefined && portlet.button_icon_alignment != null){
        	$('#portlets_modal #button-icon-alignment').val(portlet.button_icon_alignment);
        }
        
        if (portlet.button_full_width_flag != undefined && portlet.button_full_width_flag != null){
        	$('#portlets_modal input[name="button-full-width-flag"][value="'+portlet.button_full_width_flag+'"]').attr('checked','checked');
        }
        var project_id = $('#project-id').val();
        $.get('zoozoo-builder.php',{action:'file-list','project-id':project_id},function(json){
        	_this.file_list = json;
        	if (json != undefined && json != null){
	        	$.each(json,function(k,v){
	        		$('#portlets_modal #button-link-page').append(
						$('<option></option>')
						.attr('value',v.id)
						.append(v.file_name + '.html')
					);
	    		});
        	}
        	if (portlet.button_link_page != undefined && portlet.button_link_page != null){
            	$('#portlets_modal #button-link-page').val(portlet.button_link_page);
            }
        },'json');
        
        if (portlet.style != undefined){
	    	$.each( portlet.style, function( name, value ) {
	    		if ($.trim(value) != ''){
		    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
		    			$('#portlets_modal #'+ name).val(value);
		    		}else{
		    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
		    		}
	    		}
	    		
	    	});
        }
        if (portlet.attr != undefined){
	    	$.each( portlet.attr, function( name, value ) {
	    		if ($.trim(value) != ''){
	    			$('#portlets_modal #'+ name).val(value);
	    		}
	    		
	    	});
        }
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Button_Portlet = new Button_Portlet_Class();

