/*
 * portlet: anchor
 * portlet-type: anchor 
 * portlet-group: common
 * portlet-name: <i class="fa fa-anchor"></i> Anchor
 * portlet-image: assets/images/no-image.png
 */
Anchor_Portlet_Class = function(){
	this.toolbar_name = 'Anchor';
	this.anchors = {};
}
$.extend(Anchor_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Anchor_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<div></div>');
	div.append('<i class="fa fa-anchor fa-lg"></i> '+portlet.anchor_name);
	div.append(content);
	_this.anchors[portlet_id] = portlet.anchor_name;
	
	return div;
};
Anchor_Portlet_Class.prototype.portlet_toolbar = function(portlet_id,portlet){
	var _this = this;
	portlet.append($('<div class="portlet-mask" style="top: 0px; left: 0px;   position: absolute; visibility: hidden; z-index: 3000; "></div>'));
    
    // render toolbar
    var portlet_toolbar = $('<div class="portlet-toolbar btn-group" style="z-index:3001;"></div>');
    portlet_toolbar.append($('<a class="btn btn-default btn-xs portlet-toolbar-move"></a>').append('<i class="fa fa-arrows"></i> '+this.toolbar_name));
    portlet_toolbar.append(
        $('<a class="btn btn-primary btn-xs"></a>')
        .append('<i class="fa fa-files-o"></i>')
        .data('portlet-id',portlet_id)
        .click(function(){
            var portlet_id = $(this).data('portlet-id');
            var sortable_id = $('#' + portlet_id).data('sortable-id');
            var portlet = Bootstrap_Builder.portlets[portlet_id];
            $('#portlets_modal').data('copy_portlet_id',portlet_id);
            
            portlet_id = Bootstrap_Builder.guid();
            Bootstrap_Builder.portlets[portlet_id] = $.extend(true,{}, portlet);
            Bootstrap_Builder.portlets[portlet_id].portlet_id = portlet_id;
            
            _this.portlet_render(portlet_id,sortable_id);
        })
    );
    portlet_toolbar.append(
              $('<a class="btn btn-primary btn-xs"></a>')
              .append('<i class="fa fa-pencil"></i>')
              .data('portlet-id',portlet_id)
              .click(function(){
                  var portlet_id = $(this).data('portlet-id');
                  var sortable_id = $('#' + portlet_id).data('sortable-id');
                  Bootstrap_Builder.show_portlets(sortable_id,true,null,600);
                  _this.portlet_modal(portlet_id);
                  
                  $('.portlet-toolbar').hide();
                  $('.portlet-mask').css({visibility:'hidden'});
                  $('.portlet-mask').width(6);
                  // for get template block
//                	var _portlets = Bootstrap_Builder.get_portlets($('#'+portlet_id));
//            		console.log(JSON.stringify(_portlets));
                // for get template block
              })
    );
    portlet_toolbar.append(
            $('<a class="btn btn-danger btn-xs"></a>')
            .append('<i class="fa fa-trash-o"></i>')
            .data('portlet-id',portlet_id)
            .click(function(){
            	$('.portlet-toolbar').hide();
                $('.portlet-mask').css({visibility:'hidden'});
                $('.portlet-mask').width(6);
                $('#delete-modal .modal-footer > #delete-portlet').remove();
                
                var delete_portlet = $('<button type="button" class="btn btn-danger" id="delete-portlet">Delete</button>');
                var portlet_id = $(this).data('portlet-id');
                
                delete_portlet.click(function(){
                	$('#delete-modal').data('portlet-id',portlet_id);
                	$('#delete-modal').modal('hide');
                		Bootstrap_Builder.change_flag = true;
                		window.onbeforeunload = function(e) {
                            var message = 'Data you have entered may not be saved. ';
                            e.returnValue  = message;
                            return message;
                        }
                    	//$('#' + portlet_id).remove();
    	                delete Bootstrap_Builder.portlets[portlet_id];
    	                if (_this.anchors[portlet_id] != undefined){
    	                	delete  _this.anchors[portlet_id];
    	                }
                });
                $('#delete-modal .modal-footer').append(delete_portlet);
            	$('#delete-modal').modal('show');
            })
    );
    portlet.append(portlet_toolbar);
    // end render toolbar
    
    portlet.hover(function() {
        var toolbar_top = $(this).height() / 2
                - $(this).children('.portlet-toolbar').height()
                / 2;
        var toolbar_left = $(this).width() / 2 - 30;
        $(this).children('.portlet-toolbar').css({
            left : toolbar_left,
            top : toolbar_top
        });
        
        $(this).children('.portlet-toolbar').show();
        var portlet_mark_width = ($(this).outerWidth(true) > $(window).width())?$(window).width():$(this).outerWidth(true);
        $(this).children('.portlet-mask').css({'border':'3px dashed red',visibility:'visible'});
        $(this).children('.portlet-mask').css({top:'-'+$(this).find('.portlet-content > div').css('marginTop')});
        $(this).children('.portlet-mask').width(portlet_mark_width - 6);
        var portlet_content_height = $(this).find('.portlet-content').outerHeight(true);
        var portlet_content_div_height = $(this).find('.portlet-content > div').outerHeight(true);
        portlet_content_height = (portlet_content_height > portlet_content_div_height)?portlet_content_height:portlet_content_div_height;
        $(this).children('.portlet-mask').height(portlet_content_height - 6);
    }, function() {
        $(this).children('.portlet-toolbar').hide();
        $(this).children('.portlet-mask').css({visibility:'hidden'});
        $('.portlet-mask').width(6);
    });
};

Anchor_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    if (toolbar == false){
    	portlet.anchor_name = $('#portlets_modal').find('#anchor-name').val();
    }
    var value = '<a id="'+portlet_id+'"></a>';
    _this.portlet_render(portlet_id,sortable_id,value,modal_hide);
};

Anchor_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('Anchor');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=anchor&file=anchor-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    	if (portlet.anchor_name != undefined && portlet.anchor_name != ''){
            $('#portlets_modal').find('#anchor-name').val(portlet.anchor_name);
        }
    	Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Anchor_Portlet = new Anchor_Portlet_Class();
