<?php
if (!defined('APP_PATH')){
    define('APP_PATH', dirname(dirname(__FILE__)));
}
if (!class_exists('Utility')){
class Utility{
    public function __construct(){}
    public function get_plugin_assets($pattern,$plugin_path, & $plugin_assets,$plugins = array()){
        if (is_dir ( $plugin_path )) {
            if ($handle = @opendir ( $plugin_path )) {
                while ( $file = readdir ( $handle ) ) {
                    if ((is_dir ( $plugin_path . '/' . $file )) && ($file != '.') && ($file != '..') && ($file != '.svn')) {
                        $file = strtolower($file);
                        if (is_file($plugin_path . '/' . $file .'/'. $file.'-portlet.js') && (in_array($file, $plugins) || empty($plugins))){
                            $file_content = file_get_contents($plugin_path . '/' . $file .'/'. $file.'-portlet.js');
                            $matches = array();
                            //$pattern = "/^.*portlet-asset-css:\s*(.*)$/m";
                            if(preg_match_all($pattern, $file_content, $matches)){
                                if (!empty($matches[1]) && is_array($matches[1])){
                                    foreach ($matches[1] as $v){
                                        $plugin_assets[$v] = $v;
                                    }
                                }
                            }
                        }
                    }
                }
                closedir ( $handle );
            }
        }
    }
    public function guid(){
        return uniqid().'-'.rand(1,1000).'-'.rand(1,1000).'-'.rand(1,1000);
    }
    public function get_template_blocks($project_theme){
        $templates = array();
        if (trim($project_theme) != '') {
            if (is_dir ( APP_PATH.'/themes/'.$project_theme.'/templates/blocks')) {
                if ($handle = @opendir ( APP_PATH.'/themes/'.$project_theme.'/templates/blocks' )) {
                    while ( $file = readdir ( $handle ) ) {
                        $block_path = APP_PATH.'/themes/'.$project_theme.'/templates/blocks/' . $file;
                        if ((is_dir ($block_path)) && ($file != '.') && ($file != '..') && ($file != '.svn')) {
                            $group_name = explode('-', $file);
                            $group_name = ucfirst(implode(' ', $group_name));
                            $templates[$group_name] = array();
                            if ($handle1 = @opendir ( $block_path )) {
                                while ( $file1 = readdir ( $handle1 ) ) {
                                    if ((is_dir ($block_path.'/'.$file1)) && ($file1 != '.') && ($file1 != '..') && ($file1 != '.svn')) {
                                        $template = array();
                                        $template['file'] = 'themes/'.$project_theme.'/templates/blocks/' . $file .'/' . $file1 .'/'. $file1 .'.php';
                                        $name = explode('-', $file1);
                                        $name = ucfirst(implode(' ', $name));
                                        $template['name'] = $name;
                                        if (is_file($block_path. '/' . $file1 .'/thumbnail.png')){
                                            $template['thumbnail'] = 'themes/'.$project_theme.'/templates/blocks/' . $file .'/' . $file1 .'/thumbnail.png';
                                        }
                                        $templates[$group_name][$file1] = $template;
                                    }
                                }
                                closedir ( $handle1 );
                            }
                        }
                    }
                    closedir ( $handle );
                }
            }
        }
        
        return $templates;
    }
    
    public function load_plugins ($plugin_path, & $plugins){
        if (is_dir ( $plugin_path )) {
            if ($handle = @opendir ( $plugin_path )) {
                while ( $file = readdir ( $handle ) ) {
                    if ((is_dir ( $plugin_path . '/' . $file )) && ($file != '.') && ($file != '..') && ($file != '.svn')) {
                        $file = strtolower($file);
                        if (is_file($plugin_path . '/' . $file .'/'. $file.'-portlet.js')){
                            $file_content = file_get_contents($plugin_path . '/' . $file .'/'. $file.'-portlet.js');
                            $matches = array();
                            $pattern = "/^.*portlet:\s*(.*)$|^.*portlet-type:\s*(.*)$|^.*portlet-group:\s*(.*)$|^.*portlet-name:\s*(.*)$|^.*portlet-image:\s*(.*)$/m";
                            if(preg_match_all($pattern, $file_content, $matches)){
                                $plugin =  array(
                                    'portlet' => trim($matches[1][0]),
                                    'portlet-type' => trim($matches[2][1]),
                                    'portlet-group' => trim($matches[3][2]),
                                    'portlet-name' => trim($matches[4][3]),
                                    'portlet-image' => trim($matches[5][4])
                                );
                                
                                $plugins[ucfirst($plugin['portlet-group'])][$plugin['portlet-type']] = $plugin;
                            }
                            
                        }
                    }
                }
                closedir ( $handle );
            }
        }
    }
    
}
}