<?php
if (!defined('APP_PATH')){
    define('APP_PATH', dirname(dirname(__FILE__)));
}
if (!defined('UPLOADS_PATH')){
    define('UPLOADS_PATH', APP_PATH.'/data/images');
}
class Option {
    private $cache = array();
    private $file = 'untitled.php';
    public function __construct($file = null){
        $file = (is_string($file))?trim($file):null;
        if (!empty($file)){
            $this->file = $file.".php";
        }
        if (!is_file(APP_PATH.'/data/'.$this->file)){
            file_put_contents(APP_PATH.'/data/'.$this->file, "<?php exit; ?>\n".json_encode(array()));
        }
    }
    public function __get($key){
        $key = trim($key);
        if (!empty($this->cache[$key])){
            return $this->cache[$key];
        }
        
        $data = file_get_contents(APP_PATH.'/data/'.$this->file);
        $data = str_replace("<?php exit; ?>\n", "", $data);
        $value = false;
        if (!empty($data)){
            $data = json_decode($data,true);
            if (is_array($data)){
                $value = (isset($data[$key]))?$data[$key]:false;
                if ($value !== false){
                    $this->cache[$key] = $value;
                }
            }
        }
        
        return $value;
    }
    
    public function __set($key,$value){
        
        $key = trim($key);
        $this->cache[$key] = $value;
        $data = file_get_contents(APP_PATH.'/data/'.$this->file);
        $data = str_replace("<?php exit; ?>\n", "", $data);
        
        if (!empty($data)){
            $data = json_decode($data,true);
            $data = (is_array($data))?$data:array();
        }else{
            $data = array();
        }
        
        $data[$key] = $value;
        file_put_contents(APP_PATH.'/data/'.$this->file, "<?php exit; ?>\n".json_encode($data));        
    }
    
    public function __isset($key){
        $key = trim($key);
        if (!empty($this->cache[$key])){
            return true;
        }

        return ($this->__get($key) !== false)?true:false;
    }
    
    public function __unset($key){
        $key = trim($key);
        if (!empty($this->cache[$key])){
            unset($this->cache[$key]);
        }
        
        $data = file_get_contents(APP_PATH.'/data/'.$this->file);
        
        $data = str_replace("<?php exit; ?>\n", "", $data);
        
        if (!empty($data)){
            $data = json_decode($data,true);
            $data = (is_array($data))?$data:array();
        }else{
            $data = array();
        }
        if (isset($data[$key])){
            unset($data[$key]);
            file_put_contents(APP_PATH.'/data/'.$this->file, "<?php exit; ?>\n".json_encode($data));
        }
    }
    
    public function remove(){
        if (is_file(APP_PATH.'/data/'.$this->file)){
            unlink(APP_PATH.'/data/'.$this->file);
        }
    }
}