<?php
class Loger {
    
    const INFO = 1001;
    const NOTICE = 1002;
    const DEBUG = 1003;
    const WARNING = 1004;
    const ALERT = 1005;
    const ERROR = 1006;
    const CRITICAL = 1007;
    const EMERGENCY = 1008;
    
    private $level = array(
        1001 => 'INFO',
        1002 => 'NOTICE',
        1003 => 'DEBUG',
        1004 => 'WARNING',
        1005 => 'ALERT',
        1006 => 'ERROR',
        1007 => 'CRITICAL',
        1008 => 'EMERGENCY',
    );
    
    private $date_format = 'Y-m-d H:i:s';
    private $log_directory;
    private $log_file_path;
    
    
    public function __construct($log_directory){
        $this->log_directory = $log_directory;
        $oldumask = umask(0);
        if (!file_exists($log_directory)){
            mkdir($log_directory,0777,true);
        }
        umask($oldumask);
        
        $this->log_file_path = $log_directory.'/log-'.date('Y-m-d').'.txt';
    }
    
    public function set_date_format($date_format){
        return $this->date_format = $date_format;
    }
    
    public function log($level,$message,$context = array()){
        $message = $this->format_message($level, $message, $context);
        $oldumask = umask(0);
        error_log($message,3,$this->log_file_path);
        umask($oldumask);
    }
    
    private function format_message($level,$message,$context){
        $level = (isset($this->level[$level]))?$this->level[$level]:$level;
        if (! empty($context)) {
            $message .= PHP_EOL.print_r($context,true);
        }
        return "[".date($this->date_format)."] [{$level}] {$message}".PHP_EOL;
    }
}