<?php
if (!defined('APP_PATH')){
    define('APP_PATH', dirname(dirname(__FILE__)));
}
if (!defined('UPLOADS_PATH')){
    define('UPLOADS_PATH', APP_PATH.'/data/images');
}
class File_Upload{
    public function __construct(){
        //parent::__construct($_FILES);
    }
    
    public function upload($field_name, $input_name, $upload_directory, $extensions = array(), $max_file_size = null){
        $upload_directory_path = UPLOADS_PATH. $upload_directory;
        $errors = array();
        if ((isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST')) {
            $tmp_name = $this->get_tmp_name($input_name);
            $name = $this->get_name($input_name);
            $size = $this->get_size($input_name);
            $error = $this->get_error($input_name);
            if (is_string($name) && is_string($tmp_name)){
                $ext = pathinfo($name, PATHINFO_EXTENSION);
                $this->__upload($field_name, $errors, $tmp_name, $name, $size, $error, $ext, $input_name, $extensions, $max_file_size, $upload_directory_path);
                if (empty($errors) && trim($name) != ''){
                    $this->set_data($_POST,$input_name,$upload_directory.'/'.$name);
                }
            }else if (is_array($name) && is_array($tmp_name)){
                foreach ($tmp_name as $k => $tmp_name_c){
                    $ext = pathinfo($name[$k], PATHINFO_EXTENSION);
                    $this->__upload($field_name, $errors, $tmp_name_c, $name[$k], $size[$k], $error[$k], $ext, $input_name, $extensions, $max_file_size, $upload_directory_path);
                    if (empty($errors) && trim($name[$k]) != ''){
                        $this->set_data($_POST,$input_name.'.'.$k,$upload_directory.'/'.$name[$k]);
                    }
                }
            }
        }
        
        return $errors;
    }
    
    private function __upload($field_name, & $errors,$tmp_name,& $name,$size,$error,$ext,$input_name,$extensions,$max_file_size,$upload_directory_path){
        $ext = strtolower($ext);
        if ($error == UPLOAD_ERR_OK){
            if (is_uploaded_file ($tmp_name)) {
                if (empty ( $extensions ) || in_array ( $ext, $extensions )) {
                    if ($max_file_size == null || $size <= $max_file_size){
                        $oldumask = umask(0);
                        if (!file_exists($upload_directory_path)){
                            mkdir($upload_directory_path,0777,true);
                        }
                        umask($oldumask);
                        if (is_dir ( $upload_directory_path )) {
                            while ( file_exists ( $upload_directory_path . '/' . $name ) ) {
                                $name = str_replace ( '.'.$ext, '', $name ) .'-'. rand(1,1000) .'.' . $ext;
                            }
                            if (@move_uploaded_file ( $tmp_name, $upload_directory_path . '/' . $name )) {
                                // Upload success.
                                //$this->compress_image($upload_directory_path . '/' . $name, 50);
                            } else {
                                $errors[$field_name][] = __('Failed to write file to disk.');
                            }
                        } else {
                            $errors[$field_name][] = __('Missing a upload directory.');
                        }
                    }else{
                        $errors[$field_name][] = __('Your file\'s size is to large.');
                    }
                } else {
                    $errors[$field_name][] = __('The file extension is not allow to upload.');
                }
            } else {
                $errors[$field_name][] = __('No file was uploaded.');
            }
        }
    }
    
    private function compress_image($image_url, $quality) {
        if (function_exists('getimagesize') && function_exists('imagejpeg')){
            $info = getimagesize ( $image_url );
            if ($info ['mime'] == 'image/jpeg') {
                $image = imagecreatefromjpeg ( $image_url );
                imagejpeg ( $image, $image_url, $quality );
            } elseif ($info ['mime'] == 'image/png') {
                $image = imagecreatefrompng ( $image_url );
                imagepng ( $image, $image_url, $quality );
            }
        }
    }
    
    private function error_message($error){
        switch ($error){
            case UPLOAD_ERR_INI_SIZE:
                return __('The uploaded file exceeds the upload_max_filesize directive in php.ini');
                break;
            case UPLOAD_ERR_FORM_SIZE:
                return __('The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.');
                break;
            case UPLOAD_ERR_PARTIAL:
                return __('The uploaded file was only partially uploaded.');
                break;
            case UPLOAD_ERR_NO_FILE:
                return __('No file was uploaded.');
                break;
            case UPLOAD_ERR_NO_TMP_DIR:
                return __('Missing a temporary folder.');
                break;
            case UPLOAD_ERR_CANT_WRITE:
                return __('Failed to write file to disk.');
                break;
            case UPLOAD_ERR_EXTENSION:
                return __('A PHP extension stopped the file upload.');
                break;
        }
        
        return '';
    }
    
    private function get_name($input_name){
        return $this->get_data ( $_FILES, $this->build_input_name($input_name,'name') );
    }
    
    private function get_tmp_name($input_name){
        return $this->get_data ( $_FILES, $this->build_input_name($input_name,'tmp_name') );
    }
    
    private function get_type($input_name){
        return $this->get_data ( $_FILES, $this->build_input_name($input_name,'type') );
    }
    
    private function get_error($input_name){
        return $this->get_data ( $_FILES, $this->build_input_name($input_name,'error') );
    }
    
    private function get_size($input_name){
        return $this->get_data ( $_FILES, $this->build_input_name($input_name,'size') );
    }
    
    private function build_input_name($input_name,$type = 'name'){
        $name_array = explode('.', $input_name);
        $first_item = array_shift($name_array);
        array_unshift($name_array, $first_item, $type);
        return implode('.', $name_array);
    }
    
    private function get_data(array $data, $path) {
        if (empty ( $data )) {
            return null;
        }
        if (is_string ( $path ) || is_numeric ( $path )) {
            $parts = explode ( '.', $path );
        } else {
            $parts = $path;
        }
        if (is_array($parts)){
            foreach ( $parts as $key ) {
                if (is_array ( $data ) && isset ( $data [$key] )) {
                    $data = & $data [$key];
                } else {
                    return null;
                }
            }
        }
    
        return $data;
    }
    
    private function set_data(array &$data, $path, $value) {
        if (is_string ( $path ) || is_numeric ( $path )) {
            $parts = explode ( '.', $path );
        } else {
            $parts = $path;
        }
    
        $values = array ();
        $temp = &$values;
        foreach ( $parts as $key ) {
            $temp = &$temp [$key];
        }
        $temp = $value;
        unset ( $temp );
        $data = array_replace_recursive ( $data, $values );
    }
} 