<?php
if (!class_exists('Loger')){
    require APP_PATH.'/lib/loger-class.php';
}
class Error_Handler {
    private $level = array(
            E_ERROR => 'E_ERROR',
            E_WARNING => 'E_WARNING',
            E_PARSE => 'E_PARSE',
            E_NOTICE => 'E_NOTICE',
            E_CORE_ERROR => 'E_CORE_ERROR',
            E_CORE_WARNING => 'E_CORE_WARNING',
            E_COMPILE_ERROR => 'E_COMPILE_ERROR',
            E_COMPILE_WARNING => 'E_COMPILE_WARNING',
            E_USER_ERROR => 'E_USER_ERROR',
            E_USER_WARNING => 'E_USER_WARNING',
            E_USER_NOTICE => 'E_USER_NOTICE',
            E_STRICT => 'E_STRICT',
            E_DEPRECATED => 'E_DEPRECATED',
            E_USER_DEPRECATED => 'E_USER_DEPRECATED',
    );
    private $logger;
    
    public function __construct() {
        $this->logger = new Loger(APP_PATH.'/data/logs');
    }
    
    public function register(){
        register_shutdown_function (array($this,"handle_fatal_error"));
        set_error_handler (array($this,'handle_error'), E_ALL | E_STRICT );
        set_exception_handler (array ($this,'handle_exception'));
    }
    
    function handle_fatal_error() {
        $error = error_get_last ();
        if (! empty ( $error )) {
            $errno = $error ["type"];
            $errfile = $error ["file"];
            $errline = $error ["line"];
            $errstr = $error ["message"];
            if (in_array ( $errno, array (1,4,16,64) )) {
                $this->handle_error ( $errno, $errstr, $errfile, $errline );
            }
        }
    }
    public function handle_error($errno, $errstr, $errfile, $errline) {
        if (! (error_reporting () & $errno)) {
            // error do not match current error reporting level
            return true;
        }
        $errno_str = (!empty($this->level[$errno]))?$this->level[$errno]:'UNKNOWN';
        $level = $errno_str . '] [' . $errno;
        $message = $errstr . " in {$errfile}:{$errline}";
        $this->logger->log($level,$message);
    }
    public function handle_exception(Exception $e) {
        $level = 'EXCEPTION] [class:' . get_class ( $e );
        $message = $e->getMessage () . " in {$e->getFile()}:{$e->getLine()}";
        $this->logger->log($level,$message);
    }
}

if (! function_exists ( 'error_get_last' )) {
    function error_get_last() {
        return array ();
    }
}
