<?php 
global $global_plugin;
$global_plugin = true;
if (!class_exists('Utility')){
    require dirname(dirname(__FILE__)).'/utility-class.php';
}
$project_db = new Option('zoozoo-builder');
$projects = $project_db->projects;
$projects = (is_array($projects))?$projects:array();
$project_theme = '';
if (!empty($projects) && isset($projects[$_GET['project-id']])){
    $project = $projects[$_GET['project-id']];
    $project_theme = (!empty($project['project_theme']))?$project['project_theme']:'';
    if (is_file(APP_PATH.'/themes/'.$project_theme.'/config.php')){
        require APP_PATH.'/themes/'.$project_theme.'/config.php';
    }else{
        exit;
    }
}else{
    exit;
}
$plugin_css_assets = array();
$utility = new Utility();
$utility->get_plugin_assets("/^.*portlet-asset-css:\s*(.*)$/m",APP_PATH.'/plugins', $plugin_css_assets);
$utility->get_plugin_assets("/^.*portlet-asset-css:\s*(.*)$/m",APP_PATH.'/themes/'.$project_theme.'/plugins', $plugin_css_assets);

$plugin_js_assets = array();
$utility->get_plugin_assets("/^.*portlet-asset-js:\s*(.*)$/m",APP_PATH.'/plugins', $plugin_js_assets);
$utility->get_plugin_assets("/^.*portlet-asset-js:\s*(.*)$/m",APP_PATH.'/themes/'.$project_theme.'/plugins', $plugin_js_assets);

$plugins = array();
if ($global_plugin == true){
    $utility->load_plugins (APP_PATH.'/plugins', $plugins);
}
$utility->load_plugins (APP_PATH.'/themes/'.$project_theme.'/plugins', $plugins);
ksort($plugins);
$template_block = $utility->get_template_blocks($project_theme);

?><!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="">
<meta name="author" content="">

<title>Bootstrap builder</title>

<!-- Bootstrap core CSS -->
<?php if (!empty($css_files)){ ?>
<?php foreach($css_files as $css){ ?>
<link href="themes/<?php echo $project_theme; ?>/<?php echo $css;?>" media="screen" rel="stylesheet">
<?php } ?>
<?php } ?>

<?php if (!empty($google_fonts)){ ?>
<?php foreach($google_fonts as $font){ ?>
<link href='<?php echo $font; ?>' rel='stylesheet' type='text/css'>
<?php } ?>
<?php } ?>


<!-- main JS libs -->
<?php if (!empty($js_files)){ ?>
<?php foreach($js_files as $js){ ?>
<script src="themes/<?php echo $project_theme; ?>/<?php echo $js; ?>"></script>
<?php } ?>
<?php } ?>

<link href="assets/font-awesome/css/font-awesome.min.css" rel="stylesheet">
<link href="assets/codemirror/lib/codemirror.css" rel="stylesheet">
<link href="assets/codemirror/addon/scroll/simplescrollbars.css" rel="stylesheet">
<link href="assets/bootstrap-colorpicker-master/dist/css/bootstrap-colorpicker.min.css" rel="stylesheet">
<link href="assets/nestable/nestable.css" rel="stylesheet">
<link href="assets/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet">
<?php 
    if (!empty($plugin_css_assets)){
        foreach ($plugin_css_assets as $css_asset){
            if (is_file(APP_PATH.'/themes/'.$project_theme.'/'.$css_asset)){
?>
            <link href="themes/<?php echo $project_theme; ?>/<?php echo $css_asset; ?>" rel="stylesheet">
<?php 
            }else if (is_file(APP_PATH.'/'.$css_asset)){
?>
            <link href="<?php echo $css_asset; ?>" rel="stylesheet">
<?php 
            }
        }
    }
?>

<?php if (is_file(APP_PATH.'/themes/'.$project_theme.'/iframe-style.css')){?>
<link href="themes/<?php echo $project_theme; ?>/iframe-style.css" rel="stylesheet">
<?php }else{ ?>
<link href="assets/css/iframe-style.css" rel="stylesheet">
<?php } ?>

<script src="assets/js/json2.js"></script>
<script src="assets/nestable/jquery.nestable.js"></script>
<script src="assets/bootstrap-colorpicker-master/dist/js/bootstrap-colorpicker.min.js"></script>
<script src="assets/jquery/jquery-ui.min.js"></script>

<script src="assets/jQuery-File-Upload/js/jquery.iframe-transport.js"></script>
<script src="assets/jQuery-File-Upload/js/jquery.fileupload.js"></script>

<script src="assets/moment/moment.js"></script>
<script src="assets/bootstrap-datetimepicker/build/js/bootstrap-datetimepicker.min.js"></script>

<script src="assets/js/bootstrap-builder.js"></script>
<?php if (is_file(APP_PATH.'/themes/'.$project_theme.'/abstract-portlet.js')){?>
<script src="themes/<?php echo $project_theme; ?>/abstract-portlet.js"></script>
<?php }else{ ?>
<script src="assets/js/abstract-portlet.js"></script>
<?php } ?>

<?php 
    if (!empty($plugin_js_assets)){
        foreach ($plugin_js_assets as $js_asset){
            if (is_file(APP_PATH.'/themes/'.$project_theme.'/'.$js_asset)){
?>
            <script src="themes/<?php echo $project_theme; ?>/<?php echo $js_asset; ?>"></script>
<?php 
            }else if (is_file(APP_PATH.'/'.$js_asset)){
?>
            <script src="<?php echo $js_asset; ?>"></script>
<?php 
            }
        }
    }
?>

<?php 
$plugin_path = APP_PATH.'/plugins';
if (is_dir ( $plugin_path )) {
    if ($handle = @opendir ( $plugin_path )) {
        while ( $file = readdir ( $handle ) ) {
            if ((is_dir ( $plugin_path . '/' . $file )) && ($file != '.') && ($file != '..') && ($file != '.svn')) {
                if (is_file(APP_PATH.'/themes/'.$project_theme.'/plugins/'.$file.'/'.$file.'-portlet.js')){
?>
<script src="themes/<?php echo $project_theme; ?>/plugins/<?php echo strtolower($file); ?>/<?php echo strtolower($file); ?>-portlet.js"></script>                    
<?php 
                    
                }else{
?>
<script src="plugins/<?php echo strtolower($file); ?>/<?php echo strtolower($file); ?>-portlet.js"></script>
<?php 
                }
            }
        }
        closedir ( $handle );
    }
}

?>

</head>
<body>
<input type="hidden" id="project-id" value="<?php echo $_GET['project-id']; ?>">
<input type="hidden" id="project-theme" value="<?php echo $project_theme;?>">

<div data-display="none" id="component-toolbar">
    <div class="text-center"  id="component-toolbar-bars" >&nbsp;</div>
    <div style="margin-top:5px;">
      <!-- Nav tabs -->
      <ul class="nav nav-tabs" role="tablist">
        <li role="presentation" class="active"><a href="#component-tab" aria-controls="component-tab" role="tab" data-toggle="tab">Elements</a></li>
        <li role="presentation"><a href="#template-tab" aria-controls="template-tab" role="tab" data-toggle="tab">Templates</a></li>
      </ul>
      <!-- Tab panes -->
      <div class="tab-content" id="component-toolbar-tab-content"  style="margin-top:15px; overflow: auto;">
        <div role="tabpanel" class="tab-pane active" id="component-tab">
        
            <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
            <?php foreach ($plugins as $group => $components){ ?>
              <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="<?php echo md5($group); ?>-panel-heading">
                  <h4 class="panel-title">
                    <a role="button" data-toggle="collapse" href="<?php echo '#'.md5($group); ?>-panel-component" aria-expanded="true" aria-controls="<?php echo md5($group); ?>-panel-component">
                      <?php echo htmlspecialchars($group); ?>
                    </a>
                  </h4>
                </div>
                <div id="<?php echo md5($group); ?>-panel-component" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="<?php echo md5($group); ?>-panel-heading">
                  <div class="panel-body">
                    <ul class="items">
                    <?php foreach ($components as $type => $component){ ?>
                            <li class="list" data-portlet-type="<?php echo htmlspecialchars($type,ENT_NOQUOTES);?>"><?php echo $component['portlet-name']; ?></li>
                    <?php } ?>
                    </ul>
                  </div>
                </div>
              </div>
            <?php } ?>
              
            </div>
            
        </div>
        <div role="tabpanel" class="tab-pane" id="template-tab">
<?php if (!empty($template_block) && is_array($template_block)) {?>
        <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
            <?php foreach ($template_block as $group => $templates){ ?>
              <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="tg-<?php echo md5($group); ?>-panel-heading">
                  <h4 class="panel-title">
                    <a role="button" data-toggle="collapse" href="<?php echo '#tg-'.md5($group); ?>-panel-component" aria-expanded="true" aria-controls="tg-<?php echo md5($group); ?>-panel-component">
                      <?php echo htmlspecialchars($group); ?>
                    </a>
                  </h4>
                </div>
                <div id="tg-<?php echo md5($group); ?>-panel-component" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="tg-<?php echo md5($group); ?>-panel-heading">
                  <div class="panel-body">
                    <ul class="items">
                    <?php foreach ($templates as $type => $template){ ?>
                            <li class="list text-center" data-portlet-type="load-template-block" data-portlet-url="<?php echo $template['file']; ?>" style="width: 100%;">
                                <img alt="" src="<?php echo $template['thumbnail']; ?>" class="img-responsive">
                                <?php echo $template['name']; ?>
                            </li>
                    <?php } ?>
                    </ul>
                  </div>
                </div>
              </div>
            <?php } ?>
              
            </div>

<?php }?>
        </div>
      </div>
    </div>
</div>

<div class="body-wrap">
<div class="container-fluid padding-none">
    <div class="sortable" id="bootstrap-builder-container"></div>
</div>
</div>
<div class="modal fade modal-primary" id="portlets_modal" tabindex="-1" data-backdrop="static" data-keyboard="false" role="dialog" aria-labelledby="portlets_modal_label">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><i class="fa fa-times fa-lg"></i></span></button>
        <h4 class="modal-title" id="portlets_modal_label"><i class="fa fa-puzzle-piece fa-lg"></i> Components</h4>
      </div>
      <div class="modal-body" id="portlets_modal_body"></div>
    </div>
  </div>
</div>

<div class="modal fade" id="delete-modal" tabindex="-1" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-body">
          <div style="height: 60px; line-height: 60px; vertical-align: middle;">
              <i class="fa fa-exclamation-triangle"  style="font-size:4em; color:#d9534f"></i>
              Are you sure to delete this portlet ?
          </div>
      </div>
      <div class="modal-footer">
        <a type="button" class="btn btn-default" data-dismiss="modal"><span>Close</span></a>
      </div>
    </div>
  </div>
</div>

<script>
$(document).on('focusin', function(event) {
    if ($(event.target).closest(".mce-window").length) {
        e.stopImmediatePropagation();
    }
});
$(document).ready(function(){
    Bootstrap_Builder.init('themes/<?php echo $project_theme; ?>/','<?php echo $project_theme; ?>');
});
</script>
<?php if (!empty($script)) { ?>
<script>
<?php echo $script; ?>
</script>
<?php } ?>

<script src="assets/tinymce/js/tinymce/tinymce.min.js" type="text/javascript"></script>
<script src="assets/codemirror/lib/codemirror.js" type="text/javascript"></script> 
<script src="assets/codemirror/mode/xml/xml.js" type="text/javascript"></script> 
<script src="assets/codemirror/mode/javascript/javascript.js" type="text/javascript"></script> 
<script src="assets/codemirror/mode/css/css.js" type="text/javascript"></script> 
<script src="assets/codemirror/mode/htmlmixed/htmlmixed.js" type="text/javascript"></script> 
<script src="assets/codemirror/addon/edit/matchbrackets.js" type="text/javascript"></script> 
<script src="assets/codemirror/addon/scroll/simplescrollbars.js" type="text/javascript"></script> 
</body>
</html>