<?php
class Bootstrap_Portlet {
    protected $portlets;
    protected $portlet;
    protected $builder;
    protected $portlet_id;
    protected $container_tag = 'div';
    public $project_theme;
    public function __construct(& $portlets, & $portlet,$portlet_id, & $builder){
        $this->portlets = $portlets;
        $this->portlet = & $portlet;
        $this->portlet_id = $portlet_id;
        $this->builder = & $builder;
    }
    
    public function to_html(){
        $content = '';
        $content .= "<".$this->container_tag.$this->attr_str().$this->style_str()."> \n";
        $content .= $this->portlet['content']."\n";
        $content .= "</".$this->container_tag."> \n";
        
        return $content;
    }
    
    protected function attr_str(){
        $attr_str = '';
        if (!empty($this->portlet['attr']) && is_array($this->portlet['attr'])){
            foreach ($this->portlet['attr'] as $name => $value){
                if (trim($value) != ''){
                    $attr_str .= $name.'="'.htmlspecialchars($value,ENT_QUOTES).'" ';
                }
            }
        }
        
        return ($attr_str != '')?' '.$attr_str:'';
    }
    
    protected function style_str(){
        $style_str = '';
        if (!empty($this->portlet['style']) && is_array($this->portlet['style'])){
            foreach ($this->portlet['style'] as $name => $value){
                if (trim($value) != ''){
                    if (stripos($name, 'margin-') !== false || stripos($name, 'padding-') !== false || stripos($name, '-width') !== false){
                        $style_str .= $name.':'.htmlspecialchars($value,ENT_QUOTES).'px;';
                    }else{
                        $style_str .= $name.':'.htmlspecialchars($value,ENT_QUOTES).';';
                    }
                }
            }
        }
        
        return ($style_str != '')?' style="'.$style_str.'"':'';
    }
}