function render_page_builder(object){
	$("body").mask("Loading...");	
	$('#iframe-container-builder').empty();
	$('#navbar-breadcrumb').empty();
	$('#navbar-breadcrumb')
	.append(
        $('<div></div>')
        .append(
            $('<a style="cursor:pointer;"></a>').append('<i class="fa fa-folder-o"></i> Projects')
            .click(function(){
            	var Bootstrap_Builder = bootstrap_builder();
                if (Bootstrap_Builder.change_flag == false){
                    render_project_list();
                    change_iframe_width("100%");
                }else{
                	var warning_button = $('<button type="button" class="btn btn-primary" id="warning-ok"></button>').append(' &nbsp; Ok &nbsp; ');
                    warning_button.click(function(){
                    	render_project_list();
                    	change_iframe_width("100%");
                        $('#warning-modal').modal('hide');
                    });
                    $('#warning-modal .modal-body').html('<div style="height: 60px; line-height: 60px; vertical-align: middle;">' +
                            '<i style="font-size:4em; color:#d9534f" class="fa fa-exclamation-triangle"></i>'+
                            ' Data you have entered may not be saved. '+
                            '</div>');
                    $('#warning-modal .modal-footer').append(warning_button);
                    $('#warning-modal').modal('show');
                }
            })
        )
        .append(' / ')
        .append(
    		$('<a style="cursor:pointer;"></a>')
    		.append('<i class="fa fa-folder-o"></i> ')
            .append(
                $('<span></span>')
                .addClass('project-id-'+ object.project_id)
                .text(object.project_name)
            )
            .click(function(){
            	var Bootstrap_Builder = bootstrap_builder();
                if (Bootstrap_Builder.change_flag == false){
                	var project = {};
                    project.id = object.project_id;
                    project.project_name = object.project_name;
                    render_file_list(project);
                    change_iframe_width("100%");
                }else{
                	var warning_button = $('<button type="button" class="btn btn-primary" id="warning-ok"></button>').append(' &nbsp; Ok &nbsp; ');
                    warning_button.click(function(){
                    	var project = {};
                        project.id = object.project_id;
                        project.project_name = object.project_name;
                        render_file_list(project);
                        change_iframe_width("100%");
                        $('#warning-modal').modal('hide');
                    });
                    $('#warning-modal .modal-body').html('<div style="height: 60px; line-height: 60px; vertical-align: middle;">' +
                            '<i style="font-size:4em; color:#d9534f" class="fa fa-exclamation-triangle"></i>'+
                            ' Data you have entered may not be saved. '+
                            '</div>');
                    $('#warning-modal .modal-footer').append(warning_button);
                    $('#warning-modal').modal('show');
                }
            	
            })
        )
        .append(' / ')
        .append(
    		$('<div class="btn-group" id="navbar-file-list"></div>')
    		.append(
				$('<a class="btn btn-link dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></a>')
				.css({padding:'0px',fontSize:'inherit'})
				.append('<i class="fa fa-file-text-o"></i> ')
				.append(object.file_name+'.html <span class="caret"></span>')
			)
			.append('<ul class="dropdown-menu"></ul>')
        )
    );
	
	$.get('zoozoo-builder.php',{action:'file-list','project-id':object.project_id},function(json){
		var files = json;
		for(var id  in files){
			var file = files[id];
			$('#navbar-file-list > .dropdown-menu')
			.append(
				$('<li></li>').append(
					$('<a style="cursor:pointer;"></a>')
					.data('id',file.id)
	                .data('file_name',file.file_name)
	                .data('project_id',object.project_id)
	                .data('project_name',object.project_name)
					.append('<i class="fa fa-file-text-o"></i> ')
					.append(file.file_name+'.html')
					.click(function(){
						var object = $(this).data();
						var Bootstrap_Builder = bootstrap_builder();
	                    if (Bootstrap_Builder.change_flag == false){
	    					render_page_builder(object)
	                    }else{
	                 	   var warning_button = $('<button type="button" class="btn btn-primary" id="warning-ok"></button>').append(' &nbsp; Ok &nbsp; ');
	                        warning_button.click(function(){
	                        	render_page_builder(object)
	        					$('#warning-modal').modal('hide');
	                        });
	                        $('#warning-modal .modal-body').html('<div style="height: 60px; line-height: 60px; vertical-align: middle;">' +
	                                '<i style="font-size:4em; color:#d9534f" class="fa fa-exclamation-triangle"></i>'+
	                                ' Data you have entered may not be saved. '+
	                                '</div>');
	                        
	                        $('#warning-modal .modal-footer').append(warning_button);
	                        $('#warning-modal').modal('show');
	                    }
					})
				)
			);
		}
	},'json');
	
	$('#iframe-container-builder')
	.append(
		$('<iframe src="zoozoo-builder.php?action=iframe-builder&project-id='+object.project_id+'" id="iframe-preview"></iframe>').load(function(){
			$.get('zoozoo-builder.php',{'action':'get-file','project-id':object.project_id,'file-id':object.id},function(json){
				var file = json;
				if (file.settings != undefined && file.settings.background_color != undefined && file.settings.background_color != ''){
					$('#iframe-preview').contents().find('body').css({backgroundColor:file.settings.background_color});
				}
				var portlets = (file.portlets != undefined && file.portlets != null)?$.parseJSON(file.portlets):{};
				if( (typeof portlets === "object") && (portlets !== null)){
    				var iframe = document.getElementById("iframe-preview");
    			    if (iframe) {
    			       var iframeContent = (iframe.contentWindow || iframe.contentDocument);
    			       if (iframeContent.Bootstrap_Builder != undefined){
    			    	   if (iframeContent.Bootstrap_Builder.load_sortable != undefined){
    			    		   iframeContent.Bootstrap_Builder.load_sortable = false;
    			    	   }
    			    	   iframeContent.Bootstrap_Builder.display_portlets(portlets);
    			    	   if (iframeContent.Bootstrap_Builder.load_sortable != undefined){
    			    		   iframeContent.Bootstrap_Builder.load_sortable = true;
    			    	   }
    			    	   if (iframeContent.Bootstrap_Builder.sortable != undefined){
    			    		   iframeContent.Bootstrap_Builder.sortable();
    			    	   }
    			       }
    			    }
				}else{
					if (iframeContent.Bootstrap_Builder.load_sortable != undefined){
						iframeContent.Bootstrap_Builder.load_sortable = false;
					}
					iframeContent.Bootstrap_Builder.display_portlets({});
					if (iframeContent.Bootstrap_Builder.sortable != undefined){
						iframeContent.Bootstrap_Builder.sortable();
					}
					if (iframeContent.Bootstrap_Builder.load_sortable != undefined){
						iframeContent.Bootstrap_Builder.load_sortable = true;
		    	    }
				}
				$("body").unmask();
				if ($.isEmptyObject(portlets)){
					$('#iframe-preview').contents().find('#bootstrap-builder-container')
					.append('<h4 class="text-center text-muted" id="bhb-f-intro">DRAG THE TOOLBAR ELEMENTS AND TEMPLATES TO BUILD FILE</h4>');
				}
			},'json');
			resize_iframe();
	    })
	);
	
	$('#navbar-button').empty();
    $('#navbar-button')
    .append(
	    $('<div class="btn-group"></div>')
	    .append(
    		$('<a class="btn btn-default btn-sm"></a>')
    		.append('<i class="fa fa-desktop fa-lg"></i>')
    		.click(function(){
    			change_iframe_width("100%");
    		})
	    )
	    .append(
            $('<a class="btn btn-default btn-sm" id=""></a>')
            .append('<i class="fa fa-tablet fa-lg"></i>')
            .click(function(){
            	change_iframe_width("940px");
            })
        )
        .append(
            $('<a class="btn btn-default btn-sm" id=""></a>')
            .append('<i class="fa fa-mobile fa-lg"></i>')
            .click(function(){
            	change_iframe_width("480px");
            })
        )
    )
    .append(' ')
    .append(
	    $('<div class="btn-group" id="file-components"></div>')
	    .append(
	       $('<a class="btn btn-info btn-sm" id="file-setting"></a>')
	       .append('<i class="fa fa-cog fa-lg"></i> Setting')
	       .click(function(){
	    	   $('#file-setting-modal').data('file-id',object.id);
	    	   $('#file-setting-modal').data('project-id',object.project_id);
	    	   $('#file-setting-modal').modal('show');
	       })
	    )
    )
    .append(' ')
    .append(
	    $('<div class="btn-group" id="file-components"></div>')
	    .append(
	       $('<a class="btn btn-default btn-sm" id="file-preview"></a>')
	       .append('<i class="fa fa-desktop fa-lg"></i> Preview ')
	       .click(function(){
	    	   var Bootstrap_Builder = bootstrap_builder();
	           if (Bootstrap_Builder.change_flag == false){
	        	   $('#file-exit-preview').show();
	        	   $('#file-preview').hide();
	        	   $('#file-save-change').hide();
	        	   $('#file-components').hide();
	        	   $("body").mask("Loading...");
	               $('#iframe-preview').attr('src','zoozoo-builder.php?action=preview&project-id='+object.project_id+'&file-id='+object.id)
	               .load(function(){
	            	   $("body").unmask();
	               });
	           }else{
	               $('#warning-modal .modal-body').html('<div style="height: 60px; line-height: 60px; vertical-align: middle;">' +
	                       '<i style="font-size:4em; color:#d9534f" class="fa fa-exclamation-triangle"></i>'+
	                       ' Please, click "Save change" button to save your page before do other action.'+
	                       '</div>');
	                $('#warning-modal').modal('show');
	           }
	       })
	    )
	    .append(
	        $('<div class="btn-group"></div>')
	        .append(
	           $('<a class="btn btn-primary btn-sm" id="file-save-change"></a>')
	           .append('<i class="fa fa-check fa-lg"></i> Save')
	           .click(function(){
	        	   $("body").mask("Loading...");
	               var iframe = document.getElementById("iframe-preview");
	                var iframeContent;
	                if (iframe) {
	                   iframeContent = (iframe.contentWindow || iframe.contentDocument);
	                }
	                iframeContent.Bootstrap_Builder.change_flag = false;
	                iframeContent.onbeforeunload = null;
	                var portlets = iframeContent.Bootstrap_Builder.get_portlets();
	                $.post('zoozoo-builder.php',{action:'update-file','project-id':object.project_id,'file-id':object.id,portlets:JSON.stringify(portlets)},function(json){
	                	var file = json;
	                	var file_html_content = $('<div></div>').append(html_beautify(file.file_html_content)).html();
	                	$.post('zoozoo-builder.php',{action:'update-file-content','project-id':object.project_id,'file-id':object.id,file_html_content:file_html_content},function(json){
	                		$("body").unmask();
	                		show_message('<i class="fa fa-check" style="font-size:2em;"></i> The data of file has been updated successfully');
	                	},'json');
	                },'json');
	           })
	        )
	    )
    )
    .append(
       $('<a class="btn btn-danger btn-sm" id="file-exit-preview"></a>')
       .append('<i class="fa fa-times fa-lg"></i>  Exit preview ')
       .click(function(){
    	   $('#file-exit-preview').hide();
    	   $('#file-preview').show();
    	   $('#file-save-change').show();
    	   $('#file-components').show();
    	   render_page_builder(object);  
       })
       .hide()
    );
    resize_iframe();
    if ($('.main-content').data('main-sidebar') == true){
    	sidebar_toggle();
    }
}

function render_project_list(){
	$('#iframe-container-builder').empty();
	$('#navbar-button').empty();
	$('#navbar-button')
	.append(
	   $('<a class="btn btn-primary  btn-sm"></a>')
	   .append('<i class="fa fa-plus-circle fa-lg"></i> New project')
	   .click(function(){
		   $('#project-modal #div-project-theme').empty();
		   $('#project-modal #div-project-theme').append('<select class="form-control" id="project-theme" name="project-theme"></select>');
		   $.get('zoozoo-builder.php?action=theme-list',function(themes){
			   $('#project-modal-label').html('<i class="fa fa-folder-o  fa-lg"></i> New project');
	           $('#project-modal').data('action','new-project');
	           $('#project-modal #div-project-theme > #project-theme').empty();
	           if (themes != undefined && !$.isEmptyObject(themes)){
	        	   $.each(themes,function(k,v){
	        		   $('#project-modal #div-project-theme > #project-theme').append(
        				   $('<option></option>').attr('value',k).append(v)
	        		   );
	        	   });
	           }
	           $('#project-modal').modal('show');   
		   },'json');
	   })
	);
	$('#navbar-breadcrumb').empty();
	$('#navbar-breadcrumb').append('<div><i class="fa fa-folder-o"></i> Projects</div>');
	$('#iframe-container-builder')
    .append(
	    $('<div id="iframe-preview"></div>')
	    .append(
    	    $('<div class="container-fluid"></div>')
    	    .append(
               $('<div class="row text-center"></div>')
               .append(
                   $('<div class="col-xs-12" id="project-list"></div>')
               )
            )
	    )
    );
	
	$.get('zoozoo-builder.php',{action:'project-list'},function(json){
		$('#mnu_main_navigation').empty();
		$('#mnu_main_navigation')
		.append(
			$('<li></li>')
			.css({cursor:'pointer'})
			.addClass('active')
			.click(function(){
				var Bootstrap_Builder = bootstrap_builder();
                if (Bootstrap_Builder.change_flag == false){
            	    render_project_list();
                }else{
                	var warning_button = $('<button type="button" class="btn btn-primary" id="warning-ok"></button>').append(' &nbsp; Ok &nbsp; ');
                    warning_button.click(function(){
                    	render_project_list();
                    	$('#warning-modal').modal('hide');
                    });
                    $('#warning-modal .modal-body').html('<div style="height: 60px; line-height: 60px; vertical-align: middle;">' +
                            '<i style="font-size:4em; color:#d9534f" class="fa fa-exclamation-triangle"></i>'+
                            ' Data you have entered may not be saved. '+
                            '</div>');
                    $('#warning-modal .modal-footer').append(warning_button);
                    $('#warning-modal').modal('show');
                    
                }
            })
			.append(
				$('<a></a>')
				.append('<i class="fa fa-folder-o"></i> ')
				.append(
				  $('<span></span>')
				  .text('HTML Projects')
				)
			)
		);
	    
		for(var id  in json){
			var project = json[id];
			$('#project-list')
	        .append(
	            $('<div class="project-item" style="cursor:pointer;" ></div>')
	            .data('id',project.id)
	            .data('project_name',project.project_name)
	            .append(
	                $('<i class="fa fa-folder-o" style="font-size:4em;"></i>')
	                .click(function(){
		            	var project = $(this).parent().data();
		            	render_file_list(project);
		            })
	            )
	            .append('<br> ')
	            .append(
            		$('<span></span>')
            		.addClass('project-id-'+project.id)
            		.text(project.project_name)
            		.click(function(){
		            	var project = $(this).parent().data();
		            	render_file_list(project);
		            })
	            )
	            .append(
            		$('<div class="item-mask"></div>')
            		.click(function(){
		            	var project = $(this).parent().data();
		            	render_file_list(project);
		            })
	            )
	            .append(
            		$('<div class="btn-group"></div>')
            		.append(
        				$('<a class="btn btn-warning btn-xs"><i class="fa fa-cloud-download"></i></a>')
        				.click(function(e){
        					var project = $(this).parent().parent().data();
    				    	var Bootstrap_Builder = bootstrap_builder();
    			               if (Bootstrap_Builder.change_flag == false){
    			            	   $('body').mask('Creating file...');
    			            	   var download_token = _s4() + _s4() + '-' + _s4() + '-' + _s4() + '-' + _s4() + '-' + _s4() + _s4() + _s4();
    			            	   delete_cookie("download_token");
    			            	   var download_timer = setInterval(function(){
    			            		   var token = get_cookie( "download_token" );
    			            		   if(token == download_token) {
    		            		    	  $('body').unmask()
    		            		    	  clearTimeout(download_timer);
    		            		    	  delete_cookie("download_token");
    		            		       }
    			            		} ,1000);
    			                   $('#iframe-download').attr('src','zoozoo-builder.php?action=download-project&project-id='+project.id +'&download-token='+download_token);
    			               }else{
    			                   $('#warning-modal .modal-body').html('<div style="height: 60px; line-height: 60px; vertical-align: middle;">' +
    			                           '<i style="font-size:4em; color:#d9534f" class="fa fa-exclamation-triangle"></i>'+
    			                           ' Please, click "Save change" button to save your page before do other action.'+
    			                           '</div>');
    			                    $('#warning-modal').modal('show');
    			               }
        				})
            		)
            		.append(
        				$('<a class="btn btn-warning btn-xs"><i class="fa fa-pencil"></i></a>')
        				.click(function(e){
        					var project = $(this).parent().parent().data();
    				    	$('#project-modal #div-project-theme').empty();
    				    	$.get('zoozoo-builder.php',{action:'get-project','project-id':project.id},function(json){
    		        		   var project = json;
    		        		   $('#project-modal-label').html('<i class="fa fa-folder-o  fa-lg"></i> Edit project');
    		                   $('#project-modal #project-name').val(project.project_name);
    		                   $('#project-modal #div-project-theme').html('<p class="form-control-static">'+project.project_theme_name+'</p>');
    		                   $('#project-modal #project-form')
    		                   .append(
    		                       $('<input type="hidden" id="project-id" name="project-id">').val(project.id)
    		                   );
    		                   $('#project-modal').data('action','update-project');
    		                   $('#project-modal').modal('show');
    		        	    },'json');
        				})
            		)
            		.append(
        				$('<a class="btn btn-danger btn-xs"><i class="fa fa-trash-o"></i></a>')
        				.click(function(e){
        					var project = $(this).parent().parent().data();
    				    	$('#delete-project-modal').data('project-id',project.id);
    			        	$('#delete-project-modal').modal('show');
        				})
            		)
	            )
	         );
			
		}
		$('#project-list')
        .append(
            $('<div class="project-item" id="new-project" style="cursor:pointer; margin-top:35px;" ></div>')
            .append(
                $('<i class="fa fa-plus-circle" style="font-size:1.4em;"></i>')
            )
            .append(' New project')
            .click(function(){
            	$('#project-modal #div-project-theme').empty();
 			   	$('#project-modal #div-project-theme').append('<select class="form-control" id="project-theme" name="project-theme"></select>');
                $.get('zoozoo-builder.php?action=theme-list',function(themes){
     			   $('#project-modal-label').html('<i class="fa fa-folder-o  fa-lg"></i> New project');
     	           $('#project-modal').data('action','new-project');
     	           $('#project-modal #div-project-theme > #project-theme').empty();
     	           if (themes != undefined && !$.isEmptyObject(themes)){
     	        	   $.each(themes,function(k,v){
     	        		   $('#project-modal #div-project-theme > #project-theme').append(
             				   $('<option></option>').attr('value',k).append(v)
     	        		   );
     	        	   });
     	           }
     	           $('#project-modal').modal('show');   
     		   },'json');
            })
         );
		
	},'json');
	
	if ($('.main-content').data('main-sidebar') == false){
    	sidebar_toggle();
    }
	resize_iframe();
}

function render_file_list(project){
	$('#iframe-container-builder').empty();
	$('#navbar-button').empty();
    $('#navbar-button')
    .append(
       $('<a class="btn btn-primary btn-sm"></a>')
       .append('<i class="fa fa-cloud-download fa-lg"></i> Project')
       .click(function(){
    	   var Bootstrap_Builder = bootstrap_builder();
           if (Bootstrap_Builder.change_flag == false){
        	   $('body').mask('Creating file...');
        	   var download_token = _s4() + _s4() + '-' + _s4() + '-' + _s4() + '-' + _s4() + '-' + _s4() + _s4() + _s4();
        	   delete_cookie("download_token");
        	   var download_timer = setInterval(function(){
        		   var token = get_cookie( "download_token" );
        		   if(token == download_token) {
    		    	  $('body').unmask()
    		    	  clearTimeout(download_timer);
    		    	  delete_cookie("download_token");
    		       }
        		} ,1000);
               $('#iframe-download').attr('src','zoozoo-builder.php?action=download-project&project-id='+project.id +'&download-token='+download_token);
           }else{
               $('#warning-modal .modal-body').html('<div style="height: 60px; line-height: 60px; vertical-align: middle;">' +
                       '<i style="font-size:4em; color:#d9534f" class="fa fa-exclamation-triangle"></i>'+
                       ' Please, click "Save change" button to save your page before do other action.'+
                       '</div>');
                $('#warning-modal').modal('show');
           }
       })
    )
    .append(' ')
    .append(
       $('<a class="btn btn-primary btn-sm"></a>')
       .append('<i class="fa fa-plus-circle fa-lg"></i> New file')
       .click(function(){
    	   $('#file-modal #file-form')
           .append(
               $('<input type="hidden" id="project-id" name="project-id">').val(project.id)
           );
    	   $('#file-modal #file-form #file-name').val('');
           $('#file-modal-label').html('<i class="fa fa-file-text-o"></i> New file');
           $('#file-modal').data('action','new-file');
           $('#file-modal').modal('show');
       })
    );
    
    $('#navbar-breadcrumb').empty();
    $('#navbar-breadcrumb')
    .append(
		$('<div></div>')
		.append(
			$('<a style="cursor:pointer;"></a>').append('<i class="fa fa-folder-o"></i> Projects')
			.click(function(){
				render_project_list();
			})
		)
		.append(' / <i class="fa fa-folder-o"></i> ')
		.append(
			$('<span></span>')
			.addClass('project-id-'+ project.id)
			.text(project.project_name)
		)
    );
	$('#iframe-container-builder')
    .append(
        $('<div id="iframe-preview"></div>')
        .append(
            $('<div class="container-fluid"></div>')
            .append(
               $('<div class="row text-center"></div>')
               .append(
                   $('<div class="col-xs-12" id="file-list"></div>')
               )
            )
        )
    );
    
	$.get('zoozoo-builder.php',{action:'file-list','project-id':project.id},function(json){
	   $('#file-modal').data('project-id',project.id);
	   var files = json;
	   for(var id  in files){
           var file = files[id];
           $('#file-list')
           .append(
               $('<div class="file-item" style="cursor:pointer;" ></div>')
               .data('id',file.id)
               .data('file_name',file.file_name)
               .data('project_id',project.id)
               .data('project_name',project.project_name)
               .append(
                   $('<i class="fa fa-file-text-o" style="font-size:4em; margin-bottom:5px;"></i>')
                   .click(function(){
		            	var object = $(this).parent().data();
		            	render_page_builder(object)
		            })
               )
               .append('<br> ')
               .append(
                   $('<span></span>')
                   .addClass('project-id-'+file.id)
                   .click(function(){
		            	var object = $(this).parent().data();
		            	render_page_builder(object)
		            })
                   .text(file.file_name+'.html')
               )
               .append(
            		$('<div class="item-mask"></div>')
            		.click(function(){
		            	var object = $(this).parent().data();
		            	render_page_builder(object)
		            })
	            )
	            .append(
            		$('<div class="btn-group"></div>')
            		.append(
        				$('<a class="btn btn-warning btn-xs"><i class="fa fa-cloud-download"></i></a>')
        				.click(function(e){
        					var object = $(this).parent().parent().data();
                        	var Bootstrap_Builder = bootstrap_builder();
                            if (Bootstrap_Builder.change_flag == false){
                            	$('body').mask('Creating file...');
                            	var download_token = _s4() + _s4() + '-' + _s4() + '-' + _s4() + '-' + _s4() + '-' + _s4() + _s4() + _s4();
                            	delete_cookie("download_token");
                            	var download_timer = setInterval(function(){
    		            		   var token = get_cookie( "download_token" );
    		            		   if(token == download_token) {
    	            		    	  $('body').unmask()
    	            		    	  clearTimeout(download_timer);
    	            		    	  delete_cookie("download_token");
    	            		       }
    		            		} ,1000);
                            	$('#iframe-download').attr('src','zoozoo-builder.php?action=download-file&project-id='+object.project_id+'&file-id='+object.id + '&download-token='+download_token);
                            	
                            }else{
                         	   $('#warning-modal .modal-body').html('<div style="height: 60px; line-height: 60px; vertical-align: middle;">' +
                                        '<i style="font-size:4em; color:#d9534f" class="fa fa-exclamation-triangle"></i>'+
                                        ' Please, click "Save change" button to save your page before do other action.'+
                                        '</div>');
                         	    $('#warning-modal').modal('show');
                            }
        				})
            		)
            		.append(
        				$('<a class="btn btn-warning btn-xs"><i class="fa fa-files-o"></i></a>')
        				.click(function(e){
        					var object = $(this).parent().parent().data();
                        	var Bootstrap_Builder = bootstrap_builder();
                            if (Bootstrap_Builder.change_flag == false){
                         	   $('#file-modal #file-form input[name="project-id"]').remove();
                                $('#file-modal #file-form input[name="file-id"]').remove();
                                $('#file-modal #file-form')
                                .append(
                                    $('<input type="hidden" id="project-id" name="project-id">').val(object.project_id)
                                )
                                .append(
                                    $('<input type="hidden" id="file-id" name="file-id">').val(object.id)
                                );
                                $('#file-modal #file-form #file-name').val(object.file_name+'-copy');
                                $('#file-modal-label').html('<i class="fa fa-file-text-o"></i> Copy file');
                                $('#file-modal').data('action','copy-file');
                                $('#file-modal #save-file').html(' &nbsp; Ok &nbsp;');
                                $('#file-modal').modal('show');
                            }else{
                         	   $('#warning-modal .modal-body').html('<div style="height: 60px; line-height: 60px; vertical-align: middle;">' +
                                                     	              '<i style="font-size:4em; color:#d9534f" class="fa fa-exclamation-triangle"></i>'+
                                                     	              ' Please, click "Save change" button to save your page before do other action.'+
                                                     	              '</div>');
                         	   $('#warning-modal').modal('show');
                            }
        				})
            		)
            		.append(
        				$('<a class="btn btn-warning btn-xs"><i class="fa fa-pencil"></i></a>')
        				.click(function(e){
        					var object = $(this).parent().parent().data();
                        	$('#file-modal #file-form input[name="project-id"]').remove();
                     	   	$('#file-modal #file-form input[name="file-id"]').remove();
                     	   	$('#file-modal #file-form')
                            .append(
                                $('<input type="hidden" id="project-id" name="project-id">').val(object.project_id)
                            )
                     	   .append(
                                $('<input type="hidden" id="file-id" name="file-id">').val(object.id)
                            );
                            $('#file-modal #file-form #file-name').val(object.file_name);
                            $('#file-modal-label').html('<i class="fa fa-file-text-o"></i> Edit file');
                            $('#file-modal').data('action','edit-file');
                            $('#file-modal').modal('show');
        				})
            		)
            		.append(
        				$('<a class="btn btn-danger btn-xs"><i class="fa fa-trash-o"></i></a>')
        				.click(function(e){
        					var object = $(this).parent().parent().data();
                        	$('#delete-file-modal').data('project-id',object.project_id);
                     	   	$('#delete-file-modal').data('file-id',object.id);
                     	   	$('#delete-file-modal').modal('show');
        				})
            		)
	            )
            );
	   }    
	   
	   $('#file-list')
       .append(
           $('<div class="file-item" style="cursor:pointer; margin-top:35px;" ></div>')
           .append(
               $('<i class="fa fa-plus-circle" style="font-size:1.4em;"></i>')
           )
           .append(' New file')
           .click(function(){
        	   $('#file-modal #file-form')
               .append(
                   $('<input type="hidden" id="project-id" name="project-id">').val(project.id)
               );
               $('#file-modal #file-form #file-name').val('');
               $('#file-modal-label').html('<i class="fa fa-file-text-o"></i> New file');
               $('#file-modal').data('action','new-file');
               $('#file-modal').modal('show');
           })
        );
        if ($('.main-content').data('main-sidebar') == false){
        	sidebar_toggle();
        }
	   
	},'json');
	
	
	resize_iframe();
}

function show_message(message,type){
    type = (type == undefined)?'success':type;
    $.notification({
        type:type,
        width:"430",
        content:message,
        html:true,
        autoClose:true,
        timeOut:"2000",
        position:"topRight",
        effect:"slide",
        animate:"fadeUp",
        easing:"jswing",
        duration:"300"});
}

function components(){
    var iframe = document.getElementById("iframe-preview");
    if (iframe) {
       var iframeContent = (iframe.contentWindow || iframe.contentDocument);
       iframeContent.Bootstrap_Builder.show_portlets();
    }
}

function bootstrap_builder(){
	var iframe = document.getElementById("iframe-preview");
    if (iframe) {
       var iframeContent = (iframe.contentWindow || iframe.contentDocument);
       return (iframeContent != undefined && iframeContent != null && iframeContent.Bootstrap_Builder != undefined)?iframeContent.Bootstrap_Builder:{change_flag:false};
    }
    
    return {change_flag:false};
}

function save_file(){
	var iframe = document.getElementById("iframe-preview");
	var iframeContent;
    if (iframe) {
       iframeContent = (iframe.contentWindow || iframe.contentDocument);
    }
    var portlets = iframeContent.Bootstrap_Builder.get_portlets();
}

function sidebar_toggle(){
	if ($('.main-content').data('main-sidebar') == false){
		$('.main-content').css({marginLeft:'230px'});
		$('.main-content').data('main-sidebar',true);
	}else{
		$('.main-content').css({marginLeft:'0px'});
		$('.main-content').data('main-sidebar',false);
	}
}


$(document).ready(function(){
	render_project_list();
	
	$('#project-modal #save-project').click(function(){
		var project_name = $.trim($('#project-modal #project-name').val());
		if (project_name != ''){
			$.post('zoozoo-builder.php?action='+$('#project-modal').data('action'),$('#project-modal #project-form').serialize(),function(json){
				var action = $('#project-modal').data('action');
				switch (action){
	    			case 'new-project':
	    				render_project_list();
	    	            show_message('<i class="fa fa-check" style="font-size:2em;"></i> The project has been added successfully');
	    				break;
	    			case 'update-project':
	    				var project = json;
	    				$('.project-id-'+project.id).text(project.project_name);
	    				show_message('<i class="fa fa-check" style="font-size:2em;"></i> The project has been edited successfully');
	    				break;
				}
				
			},'json');
			$('#project-modal').modal('hide');
		}else{
			var form_group = $('#project-modal #project-name').parent().parent();
			if (form_group.hasClass('has-error') == false){
				form_group.addClass('has-error');
				$('#project-modal #project-name').parent().append('<span class="help-block">The Project name field is required.</span>');
			}
		}
	});
	
	$('#delete-project-modal #delete-project').click(function(){
		var project_id = $('#delete-project-modal').data('project-id');
		$.get('zoozoo-builder.php',{action:'delete-project','project-id':project_id},function(json){
    	    var project = json;
    	    render_project_list();
    	    show_message('<i class="fa fa-check" style="font-size:2em;"></i> The project has been deleted successfully');
    	},'json');	
		$('#delete-project-modal').modal('hide');
	});
	$('#delete-project-modal').on('hide.bs.modal', function (e) {
		$('#delete-project-modal').data('project-id',null);
	});
	
	$('#file-modal #save-file').click(function(){
		var file_name = $.trim($('#file-modal #file-name').val());
		$('#file-modal .template-item-container').hide();
		if (file_name != ''){
	        $.post('zoozoo-builder.php?action='+$('#file-modal').data('action')+'&template-file='+$('#file-modal').data('template-file'),$('#file-modal #file-form').serialize(),function(json){
	        	var project = json;
	        	var action = $('#file-modal').data('action');
	            switch (action){
	                case 'new-file':
	                	$('#file-modal #file-form #project-id').remove();
	                    $('#file-modal #file-form #file-name').val('');
	                	show_message('<i class="fa fa-check" style="font-size:2em;"></i> The file has been added successfully');
	                	render_file_list(project);
	                	break;
	                case 'edit-file':
	                	$('#file-modal #file-form input[name="project-id"]').remove();
	                    $('#file-modal #file-form input[name="file-id"]').remove();
	                    show_message('<i class="fa fa-check" style="font-size:2em;"></i> The file has been update successfully');
	                    render_file_list(project);
	                	break;
	                case 'copy-file':
	                	$('#file-modal #file-form input[name="project-id"]').remove();
	                    $('#file-modal #file-form input[name="file-id"]').remove();
	                    show_message('<i class="fa fa-check" style="font-size:2em;"></i> The file has been copied successfully');
	                    render_file_list(project);
	                	break;
	            }
	        },'json');
	        $('#file-modal').modal('hide');
		}else{
			var form_group = $('#file-modal #file-name').parent().parent();
			if (form_group.hasClass('has-error') == false){
				form_group.addClass('has-error');
				$('#file-modal #file-name').parent().append('<span class="help-block">The Project name field is required.</span>');
			}
		}
	});
	
	$('#delete-file-modal #delete-file').click(function(){
		var project_id = $('#delete-file-modal').data('project-id');
		var file_id = $('#delete-file-modal').data('file-id');
		$.get('zoozoo-builder.php',{action:'delete-file','project-id':project_id,'file-id':file_id},function(json){
			var project = json;
			render_file_list(project);
            show_message('<i class="fa fa-check" style="font-size:2em;"></i> The file has been deleted successfully');
		},'json');
		$('#delete-file-modal').modal('hide');
	});
	
	$('#delete-file-modal').on('hide.bs.modal', function (e) {
        $('#delete-file-modal').data('project-id',null);
        $('#delete-file-modal').data('file-id',null);
    });
	
	$('#project-modal').on('hide.bs.modal', function (e) {
		$('#project-modal #project-name').parent().parent().removeClass('has-error');
		$('#project-modal .help-block').remove();
	    $('#project-modal #project-name').val('');
    });
	
	$('#warning-modal').on('hidden.bs.modal',function(){
		$('#warning-modal #warning-ok').remove();
	});
	
	$('#file-modal').on('hidden.bs.modal', function (e) {
		$('#file-modal #template-item-container').hide();
		$('#file-modal #file-name').parent().parent().removeClass('has-error');
		$('#file-modal .help-block').remove();
	    $('#file-modal .template-items > div:not(.template-empty)').remove();
	    $('#file-modal .template-items .thumbnail').removeClass('active');
	    $('#file-modal .template-items .thumbnail').addClass('active');
	    
    });
	$('#file-modal').on('show.bs.modal', function (e) {
		var action = $('#file-modal').data('action');
		if (action == 'new-file'){
			$('#file-modal #template-item-container').show();
			$('#file-modal .modal-dialog').addClass('modal-lg');
		}else{
			$('#file-modal .modal-dialog').removeClass('modal-lg');
		}
		$('#file-modal').data('template-file','empty');
		var project_id = $('#file-modal').data('project-id'); 
		$.get('zoozoo-builder.php',{action:'template-file-list','project-id':project_id},function(json){
			if ($.isEmptyObject(json) == false){
				$.each(json,function(k,v){
					var template_container = $('<div class="col-sm-3"></div>')
					.append(
						$('<div class="thumbnail"></div>')
						.append(
							$('<div class="caption text-center"></div>').append('<p>'+v.name+'</p>')
						)
					)
					$('#file-modal .template-items').append(template_container);
					var thumbnail = template_container.children('.thumbnail');
					thumbnail.data('template-file',k);
					if (v.thumbnail != undefined){
						thumbnail
						.prepend(
							$('<img style="height: 150px; width: 100%; display: block;" src="'+v.thumbnail+'" data-holder-rendered="true">')
						);
					}else{
						thumbnail
						.prepend(
							$('<img style="height: 150px; width: 100%; display: block;" src="assets/images/no-image.png" data-holder-rendered="true">')
						);
					}
				});
				
				$('#file-modal .template-items > div:not(.template-empty) > .thumbnail').each(function(){
					$(this).click(function(){
						$('#file-modal').data('template-file',$(this).data('template-file'));
						$('.template-items .thumbnail').removeClass('active');
						$(this).addClass('active');
					});
				});
			}
		},'json');
    });
	
	$('#file-modal .template-items .thumbnail').each(function(){
		$(this).click(function(){
			$('#file-modal').data('template-file',$(this).data('template-file'));
			$('.template-items .thumbnail').removeClass('active');
			$(this).addClass('active');
		});
	});
	
	$('#file-setting-modal #save-file-setting').click(function(){
		var post_data = {};
		post_data['project-id'] = $('#file-setting-modal').data('project-id');
		post_data['file-id'] = $('#file-setting-modal').data('file-id');
		var settings = {};
		settings.title = $('#file-setting-modal #file-title').val();
		settings.meta_keywords = $('#file-setting-modal #file-meta-keywords').val();
		settings.meta_description = $('#file-setting-modal #file-meta-description').val();
		settings.background_color = $('#file-setting-modal #file-background-color').val();
		post_data.settings = settings;
		$.post('zoozoo-builder.php?action=save-file-setting',post_data,function(){
			$('#file-setting-modal').modal('hide');
			show_message('<i class="fa fa-check" style="font-size:2em;"></i> The data of file has been updated successfully');
			if (settings.background_color != undefined && settings.background_color != ''){
				$('#iframe-preview').contents().find('body').css({backgroundColor:settings.background_color});
			}else{
				$('#iframe-preview').contents().find('body').css({backgroundColor:'transparent'});
			}
		},'json');
	});
	
	$('#file-setting-modal').on('show.bs.modal', function () {
		$('#file-setting-modal #file-title').val('');
		$('#file-setting-modal #file-meta-keywords').val('');
		$('#file-setting-modal #file-meta-description').val('');
		$('#file-setting-modal #file-background-color').val('');
		
		var data = {};
		data['project-id'] = $('#file-setting-modal').data('project-id');
		data['file-id'] = $('#file-setting-modal').data('file-id');
		$.get('zoozoo-builder.php?action=get-file',data,function(json){
			var file = json;
			if (file.settings != undefined){
				var settings = file.settings;
				if (settings.title != undefined && settings.title != ''){
					$('#file-setting-modal #file-title').val(settings.title);
				}
				if (settings.meta_keywords != undefined && settings.meta_keywords != ''){
					$('#file-setting-modal #file-meta-keywords').val(settings.meta_keywords);
				}
				if (settings.meta_description != undefined && settings.meta_description != ''){
					$('#file-setting-modal #file-meta-description').val(settings.meta_description);
				}
				if (settings.background_color != undefined && settings.background_color != ''){
					$('#file-setting-modal #file-background-color').val(settings.background_color);
				}
			}
		},'json');
	});
	
	$('#file-setting-modal .file-background-color-picker').colorpicker({format:'hex'});    
    $('#file-setting-modal #file-background-color').click(function(){
        $('#file-setting-modal .file-background-color-picker').colorpicker('show');  
    });
});


function resize_iframe() {
    var h = $(window).height();
    var w = $(window).width();
    $("#iframe-preview").css({
        width : "100%",
        height : (h - (51)) + "px"
    });
    $(".main-sidebar").css({
        height : (h - 4) + "px"
    });
    $(".main-menu").css({
        height : (h -20) + "px"
    });
}

function change_iframe_width(width) {
    $("#iframe-preview").animate({
        width : width
    }, 500);
    
    $('.iframe-container').animate({
        width : width
    }, 500);
}

$(function() {
	$('.main-content').data('main-sidebar',true);
	resize_iframe();
	$(window).resize(function() {
		resize_iframe();
	});
	$('#file-modal #file-name').on("keypress", function(e) {
		var value = $(this).val();
        if (e.keyCode == 13) {
        	if ($.trim(value) != ''){
        		$('#file-modal #save-file').trigger('click');
        	}
            return false;
        }
    });
	
	$('#project-modal #project-name').on("keypress", function(e) {
		var value = $(this).val();
        if (e.keyCode == 13) {
        	if ($.trim(value) != ''){
        		$('#project-modal #save-project').trigger('click');
        	}
            return false;
        }
    });
});

function get_cookie(cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for(var i=0; i<ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1);
        if (c.indexOf(name) == 0) return c.substring(name.length,c.length);
    }
    return "";
}

function delete_cookie(name) {
	document.cookie = encodeURIComponent( name ) + "=; expires=Thu, 01 Jan 1970 00:00:00 UTC"; 
}


function _s4 () {
	return Math.floor((1 + Math.random()) * 0x10000).toString(16)
			.substring(1);
};