$(function () {
    "user strict";
    $('.browse_files').on('click', function () {
        $('#input-browse').focus().click();
        return false;
    });
    if ($('.snap-content').length > 0) {
        var uploader = FIVE();
        uploader.init();
    }
})

function FIVE() {
    var destinationAfterUpload = '';
    var filesToUpload = [];
    var map;

    // Init Googlemap marker image
    var spotIconImage = new google.maps.MarkerImage("static/img/marker_r1_c4.png",
        new google.maps.Size(37.0, 35.0),
        new google.maps.Point(0, 0),
        new google.maps.Point(18.0, 35.0)
    );
    var spotIconShadow = new google.maps.MarkerImage("static/img/marker_r1_c4_shadow.png",
        new google.maps.Size(55.0, 35.0),
        new google.maps.Point(0, 0),
        new google.maps.Point(18.0, 35.0)
    );

    var init = function () {
        var jqXHR, uploadIndex = 0;

        $('#fileupload').fileupload({
            progressInterval: 50,
            bitrateInterval: 250,
            maxFileSize: 10000000, //10MB
            acceptFileTypes: /(\.|\/)(jpe?g)$/i,
            pasteZone: $(document),
            // singleFileUploads: false,//if TRUE (default), "add" will be call multiple times
            sequentialUploads: true,
            maxNumberOfFiles: 10,
            disableImageResize: true,
            imageMaxWidth: 1600,
            imageMaxHeight: 1600,
            uploadTemplateId: null,
            downloadTemplateId: null,
            autoUpload: false,
            add: function (e, data) {
                var $lstThumb = $('.thumbnails-holder');

                //Read photo at client
                $.each(data.files, function (index, file) {
                    canvasResize(file, {
                        width: 1140,
                        height: 500,
                        crop: false,
                        quality: 90,
                        //rotate: 90,
                        callback: function (imageData, width, height, exifData) {
                            // - NOT SUPPORT FILE - //
                            // Max of 10 files
                            if ($('.upload-thumbnail').length >= av_limit.files_limit) {
                                alertify.alert('Exceed max of ' + av_limit.files_limit + ' files.');
                                return true;
                            }

                            // Restrict file size
                            if (file.size >= av_limit.image_size) {// 10MB
                                alertify.alert('File ' + file.name + ' is larger than ' + av_limit.image_size / 1000000 + 'MB');
                                return false;
                            }

                            // Restrict file type: JPG only
                            if (!file.type.match(/(\.|\/)(jpe?g|png|gif)$/i)) {
                                alertify.alert('File type is not supported');
                                return false;
                            }

                            // - SUPPORTED FILE - //
                            uploadIndex++;// Index for each photo
                            var is1stFile = false;
                            if ($('.upload-thumbnail').length == 0) {
                                is1stFile = true;
                                uploadIndex = 1;
                            }

                            // Extract EXIF data
                            var tdata = $.extend({}, exifData, {title: file.name, count: uploadIndex, active: is1stFile});
                            // convert GPS data if any
                            var hasGPS = false;
                            if (tdata.GPSLatitude && tdata.GPSLongitude) {
                                tdata = convertGPSdata(tdata);
                                hasGPS = true;
                            }

                            // render HTML for thumbnail item
                            var thumbnailHtml = tmpl("tmpl-uploadThumbnail", {
                                index: uploadIndex,
                                filename: file.name,
                                imageSrc: imageData,
                                active: is1stFile,
                                hasGPS: hasGPS
                            });
                            $lstThumb.append(thumbnailHtml);
                            $('img[alt="' + file.name + '"]').resizeToParent({parent: '.upload-thumbnail'});//auto resize and crop 1:1

                            // render HTML for edit-zone
                            var editZoneHtml = tmpl("tmpl-uploadEditor", tdata);
                            data.context = uploadIndex;//KEY POINT, GRRRRRRRR !!!
                            $(".edit-zone-holder").append(editZoneHtml);

                            if (is1stFile) {
                                $('.uploader').removeClass('block-hide');// show the edit tool
                                $('.start-zone').hide();
                                $('.preview-zone img').attr('src', imageData).attr('class', 'img img-responsive');
                                confirmClosePage();
                                initMap($('#photo-' + uploadIndex + ' .map-canvas')[0]);
                            }

                            initFormHelper();

                            // List of files to upload
                            filesToUpload.push(data);
                            updateUploadEditor();
                        }
                    });
                });
            },

            send: function (e, data) {
                jqXHR = data.xhr();
            },

            progress: function (e, data) {
                // var progress = parseInt(data.loaded / data.total * 100, 10);
            },

            progressall: function (e, data) {
                var progress = 0;
                if (data.total) {
                    progress = parseInt(data.loaded / data.total * 100, 10);
                }
                showProgress(progress);
            },

            submit: function (e, data) {
                if ($('#photo-' + data.context).length != 0) {//dont send removed photos
                    var additionData = $('#photo-' + data.context + ' form').serializeArray();
                    data.formData = additionData;
                    return true;
                } else {
                    return false;
                }
            },
            success: function (e, data) {
                if (e == 'failed') {
                    alertify.alert(av_limit.text.upload_failed)
                }
            },

            done: function (e, data) {
                if (e == 'failed') {
                    alertify.alert(av_limit.text.upload_failed)
                }
            },

            fail: function () {
                alertify.alert(av_limit.text.upload_failed);
            },

            stop: function (e) {
                redirectProgress('Finished.');
                window.onbeforeunload = false;
                window.setTimeout(function () {
                    redirectProgress(av_limit.text.upload_completed);
                }, 1000);
                window.setTimeout(function () {
                    window.location.href = av_limit.redirect_url;
                }, 2000);
            }
        });

        /*-- Binding events --*/
        //Cancel (remove) a photo
        $(document).on('click', '.btn-remove', function (e) {
            var r = confirm('Are you sure to remove this photo');
            if (r == true) {
                // remove photo thumbnail + editor
                $('.edit-zone.active').remove();
                if ($('.thumbnails-holder .active').prev().length) {
                    $('.thumbnails-holder .active').prev().find('a').trigger('click').end().end().remove();
                } else {
                    $('.thumbnails-holder .active').next().find('a').trigger('click').end().end().remove();
                }
                updateUploadEditor();

                // If no photo remains, reset start-zone
                if ($('.upload-thumbnail').length == 0) {
                    $('.start-zone').show();
                    $('.uploader').addClass('block-hide');
                    is1stFile = true;
                    filesToUpload = [];
                }
            }
        });

        $('.btn-upload').on('click', function (e) {
            $('.btn-upload').off('click').css({opacity: 0.5, cursor: 'wait'});
            $('html, body').animate({scrollTop: 0}, 1000);
            $('.btn-remove, .btn-save').hide();
            $('.preview-zone img').remove();
            $(document).on('click', '#myTab a', function (e) {
                e.preventDefault();
                e.stopPropagation();
            });
            $('.upload-thumbnail').parent().removeClass('active');
            // $('.edit-zone').removeClass('active');
            $('.map').addClass('disabled');
            $('.edit-zone input, .edit-zone textarea, .edit-zone select').attr('readonly', 'true');

            for (i in filesToUpload) {
                filesToUpload[i].submit();
            }
        });

        $(document).on('click', '#myTab a', function (e) {
            e.preventDefault();
            if (!$(this).closest('li').hasClass('active')) {
                $(this).tab('show');
                tabSelect($(this));
            }
        })
    }

    var tabSelect = function (_this) {
        $('.preview-zone img').attr('src', _this.find('img').attr('src'));
        initMap($('.edit-zone.active .map-canvas')[0]);
        initFormHelper();
    }

    var initMap = function (element) {
        var $_element = $(element);
        var searchInput = $_element.parent().find('.map-search');
        var autocomplete = new google.maps.places.Autocomplete(searchInput[0]);
        var latInput = $_element.parent().find('.photoLat'),
            lonInput = $_element.parent().find('.photoLon');
        var hasGPS = false;
        if (latInput.val() && lonInput.val()) hasGPS = true;

        var myLatLng = new google.maps.LatLng(21.03333, 105.85);//Hanoi, Vietnam
        if (hasGPS) {
            myLatLng = new google.maps.LatLng(latInput.val(), lonInput.val());
        }
        var myOptions = {
            zoom: (hasGPS) ? 12 : 3,
            center: myLatLng,
            scaleControl: false,
            mapTypeControl: false,
            panControl: false,
            zoomControl: true,
            streetViewControl: false,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            maxZoom: 20,
            minZoom: 2
        };

        map = new google.maps.Map(element, myOptions);

        var marker = new google.maps.Marker({
            position: myLatLng,
            icon: spotIconImage,
            shadow: spotIconShadow
        });
        if (hasGPS) marker.setMap(map);

        google.maps.event.addListener(map, 'click', function (e) {
            if (!hasGPS) marker.setMap(map);
            marker.setPosition(e.latLng);

            var lat = e.latLng.lat();
            var lon = e.latLng.lng();

            latInput.val(lat);
            lonInput.val(lon);

            // add Ready marker
            $('.thumbnails-holder .active .upload-thumbnail').addClass('ready');

            updateReadyPhoto();
        });

        autocomplete.bindTo('bounds', map);

        google.maps.event.addListener(autocomplete, 'place_changed', function () {
            var place = autocomplete.getPlace();
            if (!place.geometry) {
                // Inform the user that the place was not found and return.
                return;
            }

            // If the place has a geometry, then present it on a map.
            if (place.geometry.viewport) {
                map.fitBounds(place.geometry.viewport);
            } else {
                map.setCenter(place.geometry.location);
                map.setZoom(17);
            }
        });
    }

    var confirmClosePage = function () {
        window.onbeforeunload = function (e) {
            var msg = 'Are you sure to leave this page ?';
            e = e || window.event;
            if (e) e.returnValue = msg;
            return msg;
        }
    }

    var updateUploadEditor = function () {
        $('.totalphoto').text($('.upload-thumbnail').length);
        updateReadyPhoto();
    }

    var updateReadyPhoto = function () {
        $('.readyphoto').text($('.upload-thumbnail.ready').length);
    }

    var convertGPSdata = function (data) {
        var output = data;
        var latRef = {'N': 1, 'S': -1},
            lonRef = {'E': 1, 'W': -1};

        output.GPSLatitude = latRef[data.GPSLatitudeRef] * minuteToDegree(output.GPSLatitude);
        output.GPSLongitude = lonRef[data.GPSLongitudeRef] * minuteToDegree(output.GPSLongitude);
        return output;
    }

    var minuteToDegree = function (data) {
        return (data[0] + data[1] / 60 + data[2] / 3600);
    }

    var dateFormat = function (date, format) {
        // Calculate date parts and replace instances in format string accordingly
        format = format.replace("DD", (date.getDate() < 10 ? '0' : '') + date.getDate()); // Pad with '0' if needed
        format = format.replace("MM", (date.getMonth() < 9 ? '0' : '') + (date.getMonth() + 1)); // Months are zero-based
        format = format.replace("YYYY", date.getFullYear());
        return format;
    }

    var checkReady = function () {
        var isReady = true;
        $('.editPhoto').find('input.photoLat').each(function (index) {
            if (!$(this).val()) {
                tabSelect(index);
                mapWarningOn(index);
                isReady = false;
                return true;
            }
        });
        return isReady;
    }

    var showProgress = function (rate) {
        var $p = $('.progress-holder');
        if (!$p.is(':visible')) $p.show();
        $p.find('.progress-bar').css('width', rate + '%');
        $p.find('.progress-rate').text(rate + '%');
    }

    var hideProgress = function () {
        $('.progress-holder').hide();
    }

    var redirectProgress = function (text) {
        var $p = $('.progress-holder');
        $p.find('.progress-rate').text(text);
    }


    var initFormHelper = function () {
        $('.edit-zone.active .tagging').select2({
            theme: "bootstrap",
            minimumInputLength: 3,
            maximumSelectionLength: av_limit.tags,
            tags: true,
            tokenSeparators: [","]
        });

        $('.edit-zone.active .datepicker').datepicker({
            format: "yyyy/mm/dd",
            autoclose: true
        });

        $('.edit-zone.active .timepicker').timepicker({
            timeFormat: 'H:i',
            step: 1
        }).on('keypress', function (e) {
            e.preventDefault()
        });
    }

    var clearClientStorage = function () {
        if (window.localStorage) {
            localStorage.clear();
        }
    }

    return {init: init};
}